/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.tenshilib.common.utils;

import com.flemmli97.tenshilib.common.utils.MathUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class CircleSector {
    private final float theta;
    private final float radius;
    private final float rotAmount;
    private final Vector3d center;
    private final Vector3d rotAxis;
    private final Vector3d look;
    private final Entity entity;

    public CircleSector(Vector3d pos, Vector3d look, float radius, float theta, @Nullable Entity entity) {
        this.rotAmount = MathUtils.degToRad(theta > 120.0f ? 10.0f : (theta > 60.0f ? 5.0f : (theta > 30.0f ? 2.0f : (theta > 10.0f ? 1.0f : 0.5f))));
        this.theta = MathUtils.degToRad(theta);
        this.radius = radius;
        this.rotAxis = MathUtils.rotate(MathUtils.rotate(new Vector3d(0.0, 1.0, 0.0), new Vector3d(1.0, 0.0, 0.0), (float)MathHelper.func_181159_b((double)look.field_72450_a, (double)look.field_72449_c)), look, -MathUtils.degToRad(90.0f)).func_72432_b();
        this.center = pos;
        this.look = look.func_72432_b().func_186678_a((double)radius);
        this.entity = entity;
    }

    public boolean intersects(World world, AxisAlignedBB aabb) {
        BlockRayTraceResult blocks;
        float reach;
        if (aabb.func_72318_a(this.center)) {
            return true;
        }
        aabb = aabb.func_186662_g(0.2);
        boolean flag = false;
        float rot = -this.theta;
        Vector3d ray = MathUtils.rotate(this.rotAxis, this.look, rot);
        while (rot <= this.theta && !(flag = aabb.func_189973_a(this.center, this.center.func_72441_c(ray.field_72450_a * (double)(reach = (float)(blocks = world.func_217299_a(new RayTraceContext(this.center, this.center.func_72441_c(ray.field_72450_a * (double)this.radius, ray.field_72448_b * (double)this.radius, ray.field_72449_c * (double)this.radius), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, this.entity))).func_216347_e().func_72438_d(this.center)), ray.field_72448_b * (double)reach, ray.field_72449_c * (double)reach)))) {
            ray = MathUtils.rotate(this.rotAxis, this.look, rot += this.rotAmount);
        }
        return flag;
    }
}

